/*
 * Decompiled with CFR 0.152.
 */
package com.aeta.device_discovery.view;

import com.aeta.device_discovery.AbstractFrame;
import com.aeta.device_discovery.ComponentFactory;
import com.aeta.device_discovery.DeviceTableModel;
import com.aeta.device_discovery.ExternalBrowser;
import com.aeta.device_discovery.controller.DiscoveryController;
import com.aeta.device_discovery.model.Device;
import com.aeta.device_discovery.view.InfoWindow;
import com.aeta.device_discovery.view.SettingsWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class MainWindow
extends AbstractFrame {
    private JTable table;
    private DeviceTableModel tableModel;

    public MainWindow(DiscoveryController controller) {
        super(controller);
        controller.registerWindow(this);
        try {
            controller.sendRequest();
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Exception", 0);
        }
    }

    @Override
    protected JFrame layout() {
        JFrame mainFrame = new JFrame("AetaScan");
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.pack();
        mainFrame.setLocationByPlatform(true);
        mainFrame.setMinimumSize(new Dimension(800, 400));
        JToolBar tbar = new JToolBar();
        tbar.setFloatable(false);
        tbar.setRollover(false);
        tbar.setLayout(new FlowLayout(0));
        Image refreshImage = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("image/crystal_clear_actions/Reload.png"));
        ImageIcon refreshIcon = new ImageIcon(refreshImage.getScaledInstance(24, 24, 4));
        Image connectImage = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("image/crystal_clear_actions/Network.png"));
        ImageIcon connectIcon = new ImageIcon(connectImage.getScaledInstance(24, 24, 4));
        Image settingsImage = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("image/crystal_clear_actions/Wrench.png"));
        ImageIcon settingsIcon = new ImageIcon(settingsImage.getScaledInstance(24, 24, 4));
        Image infoImage = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("image/crystal_clear_actions/Info.png"));
        ImageIcon infoIcon = new ImageIcon(infoImage.getScaledInstance(24, 24, 4));
        tbar.add(ComponentFactory.button("Refresh", refreshIcon, new RefreshEvent()));
        tbar.add(ComponentFactory.button("Connect", connectIcon, new ConnectEvent()));
        tbar.add(new JSeparator(1));
        tbar.add(ComponentFactory.button("Settings", settingsIcon, new SettingsWindow(this)));
        tbar.add(ComponentFactory.button("Info", infoIcon, new InfoWindow(this)));
        this.tableModel = new DeviceTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setAutoCreateRowSorter(true);
        ((DefaultTableCellRenderer)this.table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.addMouseListener(new TableMouseEvent());
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 10, 10, 10));
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)tbar, "North");
        contentPane.add((Component)new JScrollPane(this.table), "Center");
        mainFrame.setContentPane(contentPane);
        return mainFrame;
    }

    public void addDevice(Device dev) {
        System.out.printf("MainWindow::addDevice called\n", new Object[0]);
        this.tableModel.insert(dev);
    }

    public int getDeviceCount() {
        return this.tableModel.getRowCount();
    }

    public Device getDevice(int index) {
        return this.tableModel.getDevice(index);
    }

    public void clearDevices() {
        this.tableModel.clear();
    }

    class ConnectEvent
    implements ActionListener {
        ConnectEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (MainWindow.this.table.getSelectedRow() > -1) {
                Device dev = MainWindow.this.tableModel.getDevice(MainWindow.this.table.convertRowIndexToModel(MainWindow.this.table.getSelectedRow()));
                try {
                    ExternalBrowser.connect(dev);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Failed to open Browser, try manually", "Exception", 0);
                }
            }
        }
    }

    class RefreshEvent
    implements ActionListener {
        RefreshEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MainWindow.this.clearDevices();
            try {
                MainWindow.this.controller.sendRequest();
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "Exception", 0);
            }
        }
    }

    class TableMouseEvent
    extends MouseAdapter {
        TableMouseEvent() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2) {
                Device dev = MainWindow.this.tableModel.getDevice(MainWindow.this.table.convertRowIndexToModel(MainWindow.this.table.getSelectedRow()));
                try {
                    ExternalBrowser.connect(dev);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Failed to open Browser, try manually", "Exception", 0);
                }
            }
        }
    }
}

