/*
 * Decompiled with CFR 0.152.
 */
package com.aeta.device_discovery.view;

import com.aeta.device_discovery.AbstractFrame;
import com.aeta.device_discovery.AbstractWindow;
import com.aeta.device_discovery.ComponentFactory;
import com.aeta.device_discovery.ExternalBrowser;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class InfoWindow
extends AbstractWindow<JDialog>
implements ActionListener,
HyperlinkListener {
    public InfoWindow(AbstractFrame mainFrame) {
        super(mainFrame);
    }

    @Override
    protected JDialog layout() {
        JDialog infoDialog = new JDialog();
        infoDialog.setTitle("About");
        infoDialog.setDefaultCloseOperation(2);
        infoDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        infoDialog.setResizable(false);
        JPanel contentPane = new JPanel(new GridBagLayout());
        JEditorPane textPane = new JEditorPane();
        textPane.setContentType("text/html");
        textPane.setEditable(false);
        textPane.addHyperlinkListener(this);
        textPane.setText("<br><b>AETA Device Discovery</b><p>Version: 1.0.3<br>Date: 5-sep-2022<br>&#169 Copyright 2012-2022 AETA AUDIO SYSTEMS<br></p><p><a href=\"http://www.aeta-audio.com\">www.aeta-audio.com</a></p>");
        Image logoImage = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("image/aeta_logo_230x200.jpg"));
        ImageIcon infoIcon = new ImageIcon(logoImage);
        GridBagConstraints gbcIcon = new GridBagConstraints();
        gbcIcon.fill = 1;
        gbcIcon.insets = new Insets(1, 10, 1, 0);
        contentPane.add((Component)new JLabel(infoIcon), gbcIcon);
        GridBagConstraints gbcText = new GridBagConstraints();
        gbcText.fill = 1;
        gbcText.insets = new Insets(1, 0, 1, 10);
        gbcText.gridx = 1;
        contentPane.add((Component)textPane, gbcText);
        JButton closeButton = ComponentFactory.button("OK", null, this);
        closeButton.setActionCommand("close");
        closeButton.setPreferredSize(ComponentFactory.buttonDimension());
        GridBagConstraints gbcButton = new GridBagConstraints();
        gbcButton.gridx = 1;
        gbcButton.gridy = 1;
        gbcButton.insets = new Insets(1, 1, 5, 1);
        contentPane.add((Component)closeButton, gbcButton);
        infoDialog.setContentPane(contentPane);
        return infoDialog;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("close")) {
            this.dispose();
        } else {
            this.show();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                ExternalBrowser.connect(event.getURL().toString());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Failed to open Browser, try manually", "Exception", 0);
            }
        }
    }
}

