/*
 * Decompiled with CFR 0.152.
 */
package com.aeta.device_discovery.controller;

import com.aeta.device_discovery.DiscoverySocket;
import com.aeta.device_discovery.controller.DiscoveryController;
import java.io.IOException;
import java.net.InetAddress;
import java.util.StringTokenizer;

public class DiscoveryServer
extends Thread {
    protected static final int port = 2382;
    protected static final String requestString = new String("AetaDiscoveryRequest;");
    protected static final String responsePrefix = new String("AetaDiscoveryResponse");
    protected static final String hostNameKey = new String("hostname:");
    protected static final String versionKey = new String("sw_version:");
    protected static final String macAddrKey = new String("hw_addr:");
    protected static final String deviceKey = new String("device:");
    protected static final String serialnoKey = new String("serialno:");
    protected static final String ipKey = new String("ip:");
    protected final DiscoverySocket socket = new DiscoverySocket(2382);
    protected final DiscoveryController controller;

    public DiscoveryServer(DiscoveryController ctrl) throws IOException {
        this.controller = ctrl;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    DiscoverySocket.DiscoveryMessage msg = this.socket.catchResponse();
                    if (!msg.data.startsWith(responsePrefix)) continue;
                    this.handleResponse(msg);
                }
            }
            catch (Exception e) {
                System.out.println(e);
                continue;
            }
            break;
        }
    }

    public void sendBroadcast() throws IOException {
        DiscoverySocket.DiscoveryMessage msg = new DiscoverySocket.DiscoveryMessage();
        msg.data = requestString;
        msg.ip = InetAddress.getByName("255.255.255.255");
        this.socket.sendRequest(msg);
    }

    public void sendUnicast(InetAddress address) throws IOException {
        DiscoverySocket.DiscoveryMessage msg = new DiscoverySocket.DiscoveryMessage();
        msg.ip = address;
        msg.data = requestString;
        this.socket.sendRequest(msg);
    }

    private void handleResponse(DiscoverySocket.DiscoveryMessage msg) {
        String devName = new String();
        String devMAC = new String();
        String devVersion = new String();
        String devType = new String();
        String devSerial = new String();
        StringTokenizer token = new StringTokenizer(msg.data, ";");
        while (token.hasMoreTokens()) {
            String s = token.nextToken();
            if (s.startsWith(hostNameKey)) {
                devName = s.substring(hostNameKey.length());
                continue;
            }
            if (s.startsWith(versionKey)) {
                devVersion = s.substring(versionKey.length());
                continue;
            }
            if (s.startsWith(macAddrKey)) {
                devMAC = s.substring(macAddrKey.length());
                continue;
            }
            if (s.startsWith(deviceKey)) {
                devType = s.substring(deviceKey.length());
                continue;
            }
            if (!s.startsWith(serialnoKey)) continue;
            devSerial = s.substring(serialnoKey.length());
        }
        this.controller.saveDevice(msg.ip.toString().substring(1), devType, devVersion, devName, devMAC, devSerial);
    }
}

