/*
 * Decompiled with CFR 0.152.
 */
package com.aeta.device_discovery.view;

import com.aeta.device_discovery.AbstractFrame;
import com.aeta.device_discovery.AbstractWindow;
import com.aeta.device_discovery.ComponentFactory;
import com.aeta.device_discovery.model.SearchParameters;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.UnknownHostException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SettingsWindow
extends AbstractWindow<JDialog>
implements ActionListener,
ItemListener {
    private JCheckBox checkboxLocal;
    private JCheckBox checkboxRemote;
    private JLabel labelIp;
    private JLabel labelPrefix;
    private JTextField textFieldIp;
    private JTextField textFieldPrefix;
    private JButton saveButton;

    public SettingsWindow(AbstractFrame mainFrame) {
        super(mainFrame);
    }

    @Override
    protected JDialog layout() {
        JDialog settingsDialog = new JDialog();
        settingsDialog.setTitle("Settings");
        settingsDialog.setDefaultCloseOperation(2);
        settingsDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        settingsDialog.setResizable(false);
        settingsDialog.setLayout(new BorderLayout());
        JPanel contentPane = new JPanel(new GridBagLayout());
        JPanel buttons = new JPanel(new FlowLayout(2));
        this.checkboxLocal = ComponentFactory.checkBox("Search the local network...", true);
        this.checkboxLocal.addItemListener(this);
        GridBagConstraints gbcCBLocal = ComponentFactory.gridBagConstraints(0, 0, new Insets(5, 5, 0, 5));
        gbcCBLocal.gridwidth = 4;
        gbcCBLocal.anchor = 21;
        contentPane.add((Component)this.checkboxLocal, gbcCBLocal);
        this.checkboxRemote = ComponentFactory.checkBox("Search in a remote network...", false);
        this.checkboxRemote.addItemListener(this);
        GridBagConstraints gbcCBRemote = ComponentFactory.gridBagConstraints(0, 1, new Insets(5, 5, 0, 5));
        gbcCBRemote.gridwidth = 4;
        gbcCBRemote.anchor = 21;
        contentPane.add((Component)this.checkboxRemote, gbcCBRemote);
        this.labelIp = ComponentFactory.label("IP address:", null);
        contentPane.add((Component)this.labelIp, ComponentFactory.gridBagConstraints(0, 2, new Insets(5, 30, 0, 0)));
        this.textFieldIp = new JTextField("", 10);
        contentPane.add((Component)this.textFieldIp, ComponentFactory.gridBagConstraints(1, 2, new Insets(5, 5, 0, 0)));
        this.labelPrefix = ComponentFactory.label("/", null);
        contentPane.add((Component)this.labelPrefix, ComponentFactory.gridBagConstraints(2, 2, new Insets(5, 5, 0, 0)));
        this.textFieldPrefix = new JTextField("32", 2);
        contentPane.add((Component)this.textFieldPrefix, ComponentFactory.gridBagConstraints(3, 2, new Insets(5, 5, 0, 5)));
        JButton closeButton = ComponentFactory.button("Cancel", null, this);
        closeButton.setActionCommand("cancel");
        closeButton.setPreferredSize(ComponentFactory.buttonDimension());
        buttons.add(closeButton);
        this.saveButton = ComponentFactory.button("Save", null, this);
        this.saveButton.setActionCommand("save");
        this.saveButton.setPreferredSize(ComponentFactory.buttonDimension());
        buttons.add(this.saveButton);
        settingsDialog.add((Component)contentPane, "Center");
        settingsDialog.add((Component)buttons, "South");
        return settingsDialog;
    }

    public void updateComponents() {
        this.labelIp.setEnabled(this.checkboxRemote.isSelected());
        this.textFieldIp.setEnabled(this.checkboxRemote.isSelected());
        this.labelPrefix.setEnabled(this.checkboxRemote.isSelected());
        this.textFieldPrefix.setEnabled(this.checkboxRemote.isSelected());
        if (this.checkboxLocal.isSelected()) {
            this.saveButton.setEnabled(true);
        } else if (this.checkboxRemote.isSelected()) {
            this.saveButton.setEnabled(true);
        } else {
            this.saveButton.setEnabled(false);
        }
    }

    public void update() {
        SearchParameters searchParam = this.getMainFrame().getController().getSearchParameter();
        this.checkboxLocal.setSelected(searchParam.searchBroadcast());
        this.checkboxRemote.setSelected(searchParam.searchRemote());
        this.textFieldIp.setText(searchParam.getAddress());
        this.textFieldPrefix.setText(String.valueOf(searchParam.getPrefix()));
        this.updateComponents();
    }

    public void save() throws UnknownHostException {
        this.getMainFrame().getController().getSearchParameter().setAddress(this.textFieldIp.getText());
        this.getMainFrame().getController().getSearchParameter().setBroadcastSearch(this.checkboxLocal.isSelected());
        this.getMainFrame().getController().getSearchParameter().setRemoteSearch(this.checkboxRemote.isSelected());
        this.getMainFrame().getController().getSearchParameter().setPrefix(Integer.parseInt(this.textFieldPrefix.getText()));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("cancel")) {
            this.dispose();
        } else if (event.getActionCommand().equals("save")) {
            try {
                this.save();
                this.dispose();
            }
            catch (UnknownHostException e) {
                JOptionPane.showMessageDialog(null, "Invalid IP Address", "Error", 0);
            }
        } else {
            this.update();
            this.show();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateComponents();
    }
}

