/*
 * Decompiled with CFR 0.152.
 */
package com.aeta.device_discovery.controller;

import com.aeta.device_discovery.controller.DiscoveryServer;
import com.aeta.device_discovery.model.Device;
import com.aeta.device_discovery.model.SearchParameters;
import com.aeta.device_discovery.view.MainWindow;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DiscoveryController {
    private final DiscoveryServer server;
    private final SearchParameters parameters = new SearchParameters();
    private static final Map<String, String> deviceTypes;
    private MainWindow window;

    static {
        HashMap<String, String> m = new HashMap<String, String>(7, 1.0f);
        m.put("scoopy+", "Scoopy+");
        m.put("scoopy+s", "Scoopy+ S");
        m.put("scoopy", "Scoopy+");
        m.put("scoopys", "Scoopy+ S");
        m.put("scoop5ip", "Scoop 5 IP");
        m.put("scoop5ips", "Scoop 5S-IP");
        m.put("scoop5", "Scoop 5");
        m.put("scoop5s", "Scoop 5S");
        m.put("scoop6", "Scoop 6");
        m.put("scoopfonerack", "ScoopFone HD Rack");
        m.put("scoopfone", "ScoopFone HD");
        m.put("scoopfoneiprack", "ScoopFone 4G Rack");
        m.put("scoopfoneip", "ScoopFone 4G");
        m.put("scoopfone5grack", "ScoopFone 5G Rack");
        m.put("scoopfone5g", "ScoopFone 5G");
        m.put("scoopfoneusrack", "ScoopFone US Rack");
        m.put("scoopfoneus", "ScoopFone US");
        m.put("scoopfoneeth", "ScoopFone IP");
        m.put("microscoop", "microScoop");
        m.put("sportcom", "ScoopTeam");
        m.put("multiscoopcntrl", "MultiScoop Control");
        m.put("multiscoopcodec", "MultiScoop Codec");
        m.put("scoopyflex", "ScoopyFlex");
        m.put("4minx", "4MinX");
        deviceTypes = Collections.unmodifiableMap(m);
    }

    public DiscoveryController() throws IOException {
        this.server = new DiscoveryServer(this);
        this.server.start();
    }

    public void registerWindow(MainWindow window) {
        this.window = window;
    }

    public void saveDevice(String ip, String type, String swVersion, String hostname, String mac, String serialno) {
        Boolean duplicate = false;
        if (deviceTypes.containsKey(type)) {
            type = deviceTypes.get(type);
        }
        Device device = new Device(ip, type, swVersion, hostname, mac, serialno);
        int i = 0;
        while (i < this.window.getDeviceCount()) {
            if (this.window.getDevice(i).equals(device)) {
                duplicate = true;
            }
            ++i;
        }
        if (!duplicate.booleanValue()) {
            this.window.addDevice(device);
        }
    }

    public InetAddress getUnicastAddress() throws UnknownHostException {
        long mask = 0L;
        int i = 0;
        while (i < this.parameters.getPrefix()) {
            mask |= (long)(1 << 31 - i);
            ++i;
        }
        byte[] bAddr = InetAddress.getByName(this.parameters.getAddress()).getAddress();
        long lAddr = (((long)bAddr[0] & 0xFFL) << 24) + (((long)bAddr[1] & 0xFFL) << 16) + (((long)bAddr[2] & 0xFFL) << 8) + ((long)bAddr[0] & 0xFFL);
        lAddr |= mask ^ 0xFFFFFFFFFFFFFFFFL;
        int i2 = 0;
        while (i2 < 4) {
            bAddr[i2] = (byte)(lAddr >> (3 - i2) * 8 & 0xFFL);
            ++i2;
        }
        return InetAddress.getByAddress(bAddr);
    }

    public void setSearchParameter(SearchParameters params) {
        this.parameters.set(params);
    }

    public SearchParameters getSearchParameter() {
        return this.parameters;
    }

    public void sendRequest() throws IOException {
        this.window.clearDevices();
        if (this.parameters.searchBroadcast().booleanValue()) {
            this.server.sendBroadcast();
        }
        if (this.parameters.searchRemote().booleanValue()) {
            this.server.sendUnicast(this.getUnicastAddress());
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            DiscoveryController controller = new DiscoveryController();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new MainWindow(DiscoveryController.this).show();
                }
            });
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Exception", "title", 0);
        }
    }
}

