/*
 * Decompiled with CFR 0.152.
 */
package com.aeta.device_discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class DiscoverySocket {
    private int port;
    private DatagramSocket socket;

    public DiscoverySocket(int port) throws IOException {
        this.port = port;
        this.socket = new DatagramSocket();
        this.socket.setBroadcast(true);
    }

    public void sendRequest(DiscoveryMessage msg) throws IOException {
        DatagramPacket packet = new DatagramPacket(msg.data.getBytes(), msg.data.length(), msg.ip, this.port);
        this.socket.send(packet);
        System.out.printf("Message sent to %s:%d\n", msg.ip.toString(), this.port);
    }

    public DiscoveryMessage catchResponse() throws IOException {
        DiscoveryMessage msg = new DiscoveryMessage();
        DatagramPacket packet = new DatagramPacket(new byte[1024], 1024);
        this.socket.receive(packet);
        msg.data = new String(packet.getData(), 0, packet.getLength());
        msg.ip = packet.getAddress();
        System.out.printf("Packet received from %s \"%s\"\n", msg.ip, msg.data);
        return msg;
    }

    public static class DiscoveryMessage {
        public InetAddress ip;
        public String data;
    }
}

