/*
 * Decompiled with CFR 0.152.
 */
package com.aeta.device_discovery;

import com.aeta.device_discovery.model.Device;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;

public class DeviceTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private final String[] columnNames;
    private final List<Device> devices = new ArrayList<Device>();

    public DeviceTableModel() {
        this.columnNames = new String[]{"Name", "Device Type", "IP Address", "Serial Number", "MAC Address", "Firmware Version"};
    }

    @Override
    public int getRowCount() {
        if (this.devices != null) {
            return this.devices.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String object = null;
        try {
            Device dev = this.devices.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    object = dev.getHostname();
                    break;
                }
                case 1: {
                    object = dev.getType();
                    break;
                }
                case 2: {
                    object = dev.getIpAddress();
                    break;
                }
                case 3: {
                    object = dev.getSerialNumber();
                    break;
                }
                case 4: {
                    object = dev.getMacAddress();
                    break;
                }
                case 5: {
                    object = dev.getSwVersion();
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return object;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new IllegalStateException("Not editable.");
    }

    public Device getDevice(int rowIndex) {
        return rowIndex > -1 ? this.devices.get(rowIndex) : null;
    }

    public void insert(Device dev) {
        int row = this.getRowCount();
        this.devices.add(row, dev);
        this.fireTableRowsInserted(row, row);
    }

    public void remove(int rowIndex) {
        if (rowIndex > -1) {
            this.devices.remove(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
    }

    public void clear() {
        this.devices.clear();
        this.fireTableDataChanged();
    }
}

